/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.roles;

import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import noppes.npcs.api.constants.RoleType;
import noppes.npcs.api.entity.data.role.IRoleBank;
import noppes.npcs.controllers.BankController;
import noppes.npcs.controllers.data.Bank;
import noppes.npcs.controllers.data.BankData;
import noppes.npcs.controllers.data.PlayerData;
import noppes.npcs.entity.EntityNPCInterface;
import noppes.npcs.roles.RoleInterface;

public class RoleBank
extends RoleInterface
implements IRoleBank {
    public int bankId = -1;

    public RoleBank(EntityNPCInterface npc) {
        super(npc);
        this.type = RoleType.BANK;
    }

    public Bank getBank() {
        Bank bank = BankController.getInstance().banks.get(this.bankId);
        if (bank != null) {
            return bank;
        }
        return BankController.getInstance().banks.values().iterator().next();
    }

    @Override
    public void interact(EntityPlayer player) {
        BankData data = PlayerData.get((EntityPlayer)player).bankData.get(this.bankId);
        if (data == null) {
            return;
        }
        data.openBankGui(player, this.npc, 0);
        this.npc.say(player, this.npc.advanced.getInteractLine());
    }

    @Override
    public void load(NBTTagCompound compound) {
        super.load(compound);
        this.type = RoleType.BANK;
        this.bankId = compound.func_74762_e("RoleBankID");
    }

    @Override
    public NBTTagCompound save(NBTTagCompound compound) {
        super.save(compound);
        compound.func_74768_a("RoleBankID", this.bankId);
        return compound;
    }
}

